/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   ucFS API Header File
::   Copyright   :   (C)2004-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   Dependant upon ucFS Release1
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __UCFS_H
#define __UCFS_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <Resource_FFS.h>
#include <usbDataTypes.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/
#define ucFS_Remove FS_Remove

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/
#pragma pack(1)


#pragma pack()
/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/

FFS_FILEHANDLE ucFS_FOpen(char const* in_pszFileName, const char *mode, NativeError_S* out_pDetailError);
void           ucFS_FClose(FFS_FILEHANDLE filehandle);
NativeError_S  ucFS_FRead(void *buf, NativeVar_S size, NativeVar_S items, FFS_FILEHANDLE filehandle);
NativeError_S  ucFS_FWrite(void const* buf, NativeVar_S size, NativeVar_S items, FFS_FILEHANDLE filehandle);
NativeError_S  ucFS_Remove(char const* in_pszName);
NativeError_S  ucFS_FError(FFS_FILEHANDLE);
void           ucFS_CloseFileSystem(void);
NativeError_S  ucFS_OpenFileSystem(void);
NativeError_S  ucFS_FileSeek(FFS_FILEHANDLE, NativeVar_S in_sByteOffset, E_FFSSeekOrigin);
NativeError_S  ucFS_FTell(FFS_FILEHANDLE);
FFS_SEARCH_HANDLE ucFS_FindFirst(char const* in_pszFileSpec, NativeVar_U in_uSearchAttributes, S_FFSFindData* out_pFileInfo, NativeError_S* out_pDetailError);
NativeError_S  ucFS_FindNext(FFS_SEARCH_HANDLE, S_FFSFindData* out_pFileInfo);
void           ucFS_FindFileClose(FFS_SEARCH_HANDLE hSearchHandle);
NativeError_S  ucFS_RenameFile(char const* in_pszExistingFilename, char const* in_pszNewFileName);
NativeError_S  ucFS_GetFileLength(char const* in_pszFileName);
NativeError_S  ucFS_CreateDirectory(char const* in_pszNewLeafDirectory);
NativeError_S  ucFS_GetDriveFreeSpace(char const* in_pszDriveName);
uint4          ucFS_GetFileLengthWithHandle(FFS_FILEHANDLE hFile, NativeError_S* out_pError);

usbHRESULT ucFS_USBMSDEV_OnUSBConnectEvent(usbHANDLE hNewDevice, usbUINT32 uNumBlocksInDevice, usbUINT32 uBlockByteSize, void** out_ppFileSystemContext);
usbHRESULT ucFS_USBMSDEV_OnUSBDisconnectEvent(void* pFileSystemContext);

/* This exists within the Framework glue that this archive is attached to */
void OnFileSystemEventFFS(char const* in_pszVolume, E_FileSysEvent);

#endif /* __UCFS_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
